/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.uicontrols.expressionbuilder;

import filenet.vw.api.VWFieldType;
import filenet.vw.api.VWStepDefinition;
import filenet.vw.toolkit.design.property.dialog.VWWorkClassProxy;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.utils.IVWPropertyData;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import filenet.vw.toolkit.utils.uicontrols.expressionbuilder.VWExpressionEditor;
import filenet.vw.toolkit.utils.uicontrols.expressionbuilder.VWItemPicker;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;

public class VWExpressionBuilderDialog
extends VWModalDialog
implements ActionListener {
    public static final int NONE = 0;
    public static final int DATA_FIELDS = 1;
    public static final int ATTACHMENT_FIELDS = 2;
    public static final int WORKFLOW_GROUPS = 4;
    public static final int FUNCTIONS = 8;
    public static final int STEP_RESPONSES = 16;
    public static final int WAITED_FOR_WORKFLOW_FIELDS = 32;
    public static final int CREATE_WORKFLOW_FIELDS = 64;
    public static final int SYSTEM_FIELDS = 128;
    public static final int SCHEMA = 256;
    public static final int XML_DATA_FIELDS = 512;
    public static final int PARTNERLINKS = 1024;
    public static final int BASIC_ATTRIBUTES = 2703;
    public static final int NORMAL = 0;
    public static final int LEFT_VALUE = 1;
    public static final int RIGHT_VALUE = 2;
    public static final int RESULT_OK = 0;
    public static final int RESULT_CANCEL = 1;
    private VWItemPicker m_itemPicker = null;
    private VWExpressionEditor m_expressionEditor = null;
    private JButton m_okButton = null;
    private JButton m_cancelButton = null;
    private JButton m_helpButton = null;
    private GridBagConstraints m_gbCons = null;
    private IVWPropertyData m_propertyData = null;
    private VWStepDefinition m_stepDefinition = null;
    private String m_expressionString = null;
    private int m_flags = 0;
    private int m_result = 1;
    private int m_orientation = 0;
    private VWWorkClassProxy m_workClassProxy = null;
    private int m_valueType = 1;
    private String m_valueName = null;
    private boolean m_isValueArray = false;
    private int m_defaultItem = 0;
    private String m_defaultSubItem = null;

    public VWExpressionBuilderDialog(Frame parentFrame, IVWPropertyData propertyData, VWStepDefinition stepDefinition, String expressionString, int flags) {
        super(parentFrame);
        this.m_propertyData = propertyData;
        this.m_stepDefinition = stepDefinition;
        this.m_expressionString = expressionString;
        this.m_flags = flags;
    }

    public VWExpressionBuilderDialog(Dialog parentDialog, IVWPropertyData propertyData, VWStepDefinition stepDefinition, String expressionString, int flags) {
        super(parentDialog);
        this.m_propertyData = propertyData;
        this.m_stepDefinition = stepDefinition;
        this.m_expressionString = expressionString;
        this.m_flags = flags;
    }

    public VWExpressionBuilderDialog(Frame parentFrame, IVWPropertyData propertyData, VWStepDefinition stepDefinition, String expressionString, int flags, int orientation) {
        super(parentFrame);
        this.m_propertyData = propertyData;
        this.m_stepDefinition = stepDefinition;
        this.m_expressionString = expressionString;
        this.m_flags = flags;
        this.m_orientation = orientation;
    }

    public VWExpressionBuilderDialog(Dialog parentDialog, IVWPropertyData propertyData, VWStepDefinition stepDefinition, String expressionString, int flags, int orientation) {
        super(parentDialog);
        this.m_propertyData = propertyData;
        this.m_stepDefinition = stepDefinition;
        this.m_expressionString = expressionString;
        this.m_flags = flags;
        this.m_orientation = orientation;
    }

    public void init() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.m_gbCons = new GridBagConstraints();
        String title = VWResource.s_expressionBuilderStr;
        if (this.m_valueName != null) {
            try {
                String subTitle = " (" + this.m_valueName + ": ";
                if (this.m_valueType != 64) {
                    subTitle = subTitle + VWFieldType.getLocalizedString(this.m_valueType);
                    if (this.m_isValueArray) {
                        subTitle = subTitle + " " + VWResource.s_array;
                    }
                } else {
                    subTitle = subTitle + VWResource.s_workflowGroupStr;
                }
                subTitle = subTitle + ")";
                title = title + subTitle;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        this.setTitle(title);
        Dimension dim = VWStringUtils.stringToDimension("685,445");
        if (dim != null) {
            this.setSize(dim);
        }
        this.initControls();
        this.initDialogControls();
    }

    public int getDialogResult() {
        return this.m_result;
    }

    public String getExpressionString() {
        return this.m_expressionEditor.getExpression();
    }

    public void setValueInfo(String valueName, int valueType, boolean isArray) {
        this.m_valueName = valueName;
        this.m_valueType = valueType;
        this.m_isValueArray = isArray;
    }

    public String getValueName() {
        return this.m_valueName;
    }

    public int getValueType() {
        return this.m_valueType;
    }

    public boolean isValueArray() {
        return this.m_isValueArray;
    }

    public void setDefaultItems(int defaultItem, String defaultSubItem) {
        this.m_defaultItem = defaultItem;
        this.m_defaultSubItem = defaultSubItem;
    }

    public void setWorkClassProxy(VWWorkClassProxy workClassProxy) {
        this.m_workClassProxy = workClassProxy;
        if (this.m_itemPicker != null) {
            this.m_itemPicker.setWorkClassProxy(workClassProxy);
        }
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.m_cancelButton) {
            this.performCancel();
        } else if (source == this.m_helpButton) {
            this.performHelp();
        } else if (source == this.m_okButton) {
            this.performOK();
        }
    }

    private void initControls() {
        this.m_gbCons.anchor = 23;
        this.m_gbCons.fill = 1;
        this.m_gbCons.gridx = 0;
        this.m_gbCons.gridy = 1;
        this.m_gbCons.gridheight = 1;
        this.m_gbCons.gridwidth = 1;
        this.m_gbCons.weightx = 1.0;
        this.m_gbCons.weighty = 0.5;
        this.m_gbCons.insets = new Insets(2, 2, 0, 2);
        this.m_expressionEditor = new VWExpressionEditor(this.m_parent);
        this.m_expressionEditor.init(this.m_propertyData, this.m_expressionString, this.m_valueType);
        this.getContentPane().add((Component)this.m_expressionEditor, this.m_gbCons);
        this.m_gbCons.anchor = 23;
        this.m_gbCons.fill = 1;
        this.m_gbCons.gridx = 0;
        this.m_gbCons.gridy = 0;
        this.m_gbCons.gridheight = 1;
        this.m_gbCons.gridwidth = 1;
        this.m_gbCons.weightx = 1.0;
        this.m_gbCons.weighty = 0.5;
        this.m_gbCons.insets = new Insets(0, 2, 0, 2);
        this.m_itemPicker = new VWItemPicker(this, this.m_propertyData, this.m_stepDefinition, this.m_flags, this.m_orientation);
        this.m_itemPicker.init(this.m_defaultItem, this.m_defaultSubItem, this.m_workClassProxy);
        this.getContentPane().add((Component)this.m_itemPicker, this.m_gbCons);
        this.m_expressionEditor.setEditorTool(this.m_itemPicker);
    }

    private void initDialogControls() {
        JPanel clientPanel = new JPanel();
        clientPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbCons = new GridBagConstraints();
        gbCons.anchor = 10;
        gbCons.fill = 0;
        gbCons.gridx = 0;
        gbCons.gridy = 0;
        gbCons.gridheight = 1;
        gbCons.gridwidth = 1;
        gbCons.weightx = 0.3;
        gbCons.weighty = 0.0;
        gbCons.insets = new Insets(0, 0, 0, 5);
        this.m_okButton = new JButton(VWResource.s_ok);
        this.m_okButton.addActionListener(this);
        clientPanel.add((Component)this.m_okButton, gbCons);
        ++gbCons.gridx;
        this.m_cancelButton = new JButton(VWResource.s_cancel);
        this.m_cancelButton.addActionListener(this);
        clientPanel.add((Component)this.m_cancelButton, gbCons);
        ++gbCons.gridx;
        gbCons.insets = new Insets(0, 0, 0, 0);
        this.m_helpButton = new JButton(VWResource.s_help);
        this.m_helpButton.addActionListener(this);
        clientPanel.add((Component)this.m_helpButton, gbCons);
        this.m_gbCons.anchor = 10;
        this.m_gbCons.fill = 0;
        this.m_gbCons.gridx = 0;
        this.m_gbCons.gridy = 2;
        this.m_gbCons.gridheight = 1;
        this.m_gbCons.gridwidth = 1;
        this.m_gbCons.weightx = 1.0;
        this.m_gbCons.weighty = 0.0;
        this.m_gbCons.insets = new Insets(8, 2, 8, 2);
        this.getContentPane().add((Component)clientPanel, this.m_gbCons);
    }

    private void performOK() {
        this.m_result = 0;
        this.setVisible(false);
    }

    private void performCancel() {
        this.m_result = 1;
        this.setVisible(false);
    }

    private void performHelp() {
        VWHelp.displayPage(VWHelp.Help_Process_Designer + "bpfdh147.htm");
    }
}

